var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"MAYAUL\">\n      <meta name=\"release\" content=\"2016\">\n      <meta name=\"book\" content=\"Tutorial\">\n      <meta name=\"created\" content=\"2015-10-30\">\n      <meta name=\"topicid\" content=\"GUID-72524F3E-12CB-4FA1-8507-B368EC4EBF86\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>Creating the fluid smoke and flames</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-72524F3E-12CB-4FA1-8507-B368EC4EBF86\"></a><div class=\"head\">\n            <h1>Creating the fluid smoke and flames</h1>\n         </div>\n         <p><a name=\"WS1A9193826455F5FF45564F421269B08A8E91350\"></a>In the next steps, you create a 3D fluid object that emits from the surface of the\n            geo_slag polygon object. \n            	 \n         </p><a name=\"WS1A9193826455F5FF45564F421269B08A8E91351\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF45564F421269B08A8E91352\"></a>To create the 3D fluid container\n         </p>\n         <ol type=\"1\" start=\"1\">\n            <li>Select \n               		  <span class=\"MenuCascade\" id=\"GUID-4D6C3734-604E-46C2-98B8-AB1A41AE3A2F\">Fluids &gt; 3D Container</span> &gt; \n               		  <img src=\"../images/GUID-D0B559A1-42F8-4DFC-BBE6-7EC64945DB21-low.png\">. \n               		\n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\">Create 3D Container with Emitter Options</span> window, select \n               		  <span class=\"MenuCascade\" id=\"GUID-244B734E-D364-4294-BBF7-4E3CCD06BBF4\">Edit &gt; Reset Settings</span> and ensure the X, Y, and Z resolution values are 10. \n               		  \n               <p><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5B0B\"></a>Keeping the fluid resolution values set to the default value of 10 ensures that the\n                  fluid simulates quickly. Later in the lesson, you increase the resolution values to\n                  improve the quality and overall appearance of the effect. \n                  		  \n               </p> \n            </li>\n            <li>Turn off \n               		  <span class=\"MenuCascade\">Add Emitter</span>. \n               		  \n               <p>This option is located between<span class=\"MenuCascade\"> Basic Fluid Attributes</span> and \n                  			 <span class=\"MenuCascade\">Basic Emitter Attributes</span>.\n                  		  \n               </p> <a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5B0C\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-35043621-033B-4DC3-9493-A5AAE92C91F9-low.png\"></div> \n            </li>\n            <li>Click \n               		  <span class=\"MenuCascade\" id=\"GUID-A7C88352-46DA-4DC5-A8A1-6C79C128FF7B\">Apply and Close</span>. \n               		\n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-77560DBC-F677-458B-9A49-ECC4217903A3\">Outliner</span>, rename fluid1 object to \n               		  <em class=\"mild\">fluid_slag_smoke</em>. \n               		\n            </li>\n            <li>To position the container at the top of the slag chute, in the \n               		  <span class=\"MenuCascade\" id=\"GUID-30830686-629E-44A4-89A9-B653C2DBEA0B\">Attribute Editor</span>, click the \n               		  <span class=\"MenuCascade\" id=\"GUID-2C195BFE-3BD4-4827-8BA7-B0E967F2D0AA\">fluid_slag_smoke</span> tab. \n               		\n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-CC44433D-4A73-48E3-9149-E99F66394E08\">Transform Attributes</span> section, set the \n               		  <span class=\"MenuCascade\" id=\"GUID-2E6CF950-39F2-4E04-BD6E-6B085FC76613\">Translate</span> values to: \n               		  <a name=\"WS1A9193826455F5FF45564F421269B08A8E91359\"></a><ul>\n                  <li>X: -7.0 \n                     			 \n                  </li>\n                  <li>Y: 16. \n                     			 \n                  </li>\n                  <li>Z: -1 \n                     			 \n                  </li>\n               </ul> <a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5B0A\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-218AFC7C-C55C-49E9-A99D-9955F5D4B0AF-low.png\"></div> \n               <p><a name=\"WS1A9193826455F5FF45564F421269B08A8E9135D\"></a>The \n                  			 <span class=\"MenuCascade\" id=\"GUID-B5ADA0DF-0C0E-46DC-9D4E-1B3C4C14E1F3\">Translate</span> values position the fluid container at the top of the slag chute. You can now add\n                  the emitter to the fluid container. \n                  		  \n               </p> \n            </li>\n         </ol><a name=\"WS1A9193826455F5FF45564F421269B08A8E9135F\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF45564F421269B08A8E91360\"></a>To emit fluid from the slag mesh\n         </p>\n         <ol type=\"1\" start=\"1\">\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-10A198CF-ED52-42C5-93CE-735F4C966079\">Outliner</span>, Ctrl-click \n               		  <em class=\"mild\">fluid_slag_smoke</em> and \n               		  <em class=\"mild\">geo_slag</em>, then select \n               		  <span class=\"MenuCascade\" id=\"GUID-83CF0699-A8CC-4DA9-8EBE-1135D04E698E\">Fluids &gt; Add/Edit Contents &gt; Emit from Object</span> &gt; \n               		  <img src=\"../images/GUID-D0B559A1-42F8-4DFC-BBE6-7EC64945DB21-low.png\">. \n               		\n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-5532FADC-6F7A-4740-9399-F669806FD834\">Emit from Objects Options</span> window that appears, select \n               		  <span class=\"MenuCascade\" id=\"GUID-C2C611AE-FCF2-42B0-93B1-A982DF3063F0\">Edit &gt; Reset Settings</span>, then set the following: \n               		  <a name=\"WS73099CC142F4875516078EA312754F1D2D4-7BFD\"></a><ul>\n                  <li>For the<span class=\"MenuCascade\" id=\"GUID-3F9D26F2-F532-4CEC-B43A-497D1AA1DDAA\"> Emitter name</span>, type \n                     				<em class=\"mild\">emitter_slag_smoke</em>. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-0969F31F-BEFD-432E-963F-8BD862898E5B\">Basic Emitter Attributes</span> section, set \n                     				<span class=\"MenuCascade\" id=\"GUID-88CD9F26-2248-4A16-AB95-550D45699399\">Emitter type</span> to \n                     				<span class=\"MenuCascade\" id=\"GUID-3E511B1B-CE10-433B-911F-A49EAB211C0A\">Surface</span>. \n                     			 \n                  </li>\n               </ul> \n            </li>\n            <li>Click \n               		  <span class=\"MenuCascade\" id=\"GUID-DF38BC35-4DD0-4F47-B718-8C75EF194BCA\">Apply and Close</span>. \n               		\n            </li>\n            <li>Rewind and play the simulation. \n               		  \n               <p><a name=\"WS1A9193826455F5FF45564F421269B08A8E91367\"></a>Notice that the fluid emits from the slag mesh, but only while the slag passes through\n                  the fluid container. Turning on \n                  			 <span class=\"MenuCascade\" id=\"GUID-8FAEC621-923D-4C51-839C-CCB1A844FA39\">Auto Resize</span> enables the fluid container to follow the slag mesh as it emits fluid. \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5B08\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-4E0F4FFE-9A83-42FB-8422-B12FAE4EC492-low.png\"></div> \n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-56BD3628-24CB-41E5-8156-8F81D4136ACE\">Outliner \n                  		  </span>select \n               		  <em class=\"mild\">fluid_slag_smoke</em>, then switch to the \n               		  <span class=\"MenuCascade\" id=\"GUID-9033006C-4617-49BD-AA62-B0CDB688D9B6\">fluid_slag_smokeShape</span> tab in the \n               		  <span class=\"MenuCascade\" id=\"GUID-A0D587EC-C127-4FB5-85EB-8513A3CEF220\">Attribute Editor</span>. \n               		\n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-96EFB173-8C2F-472C-A835-659BCCAAF356\">Auto Resize</span> section, turn on \n               		  <span class=\"MenuCascade\" id=\"GUID-2F553602-5FA3-46A9-8B17-54E21D31C35C\">Auto Resize</span>. \n               		  <a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5B07\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-FCBF9B17-2A54-40E0-89C3-74340FAAF33A-low.png\"></div> \n            </li>\n            <li>Rewind and play the simulation. \n               		  \n               <p><a name=\"WS1A9193826455F5FF45564F421269B08A8E9136B\"></a>Notice that the fluid container now resizes and follows the movements of the slag.\n                  When \n                  			 <span class=\"MenuCascade\" id=\"GUID-2059184C-D8A0-40EB-86C3-37EA413DCD91\">Auto Resize</span> is on, the boundaries (<span class=\"MenuCascade\" id=\"GUID-9B3D6DBA-93A2-41DB-B9DE-B45F6E911E44\">Size</span> and \n                  			 <span class=\"MenuCascade\" id=\"GUID-1E7B7246-6283-4DF0-AD3C-398C92641C56\">Resolution</span>) of a fluid container dynamically resize as the fluid density increases or decreases.\n                  \n                  			 <span class=\"MenuCascade\" id=\"GUID-48749F29-34E8-47CF-A14B-2F799FAF6D7B\">Auto Resize</span> keeps the fluid container relatively small, so it works well with fluid effects that\n                  move quickly, such as a missile vapor trail or the rolling smoke of an explosion.\n                  \n                  		  \n               </p> \n               <p><a name=\"WS73099CC142F4875516078EA312754F1D2D4-7BFA\"></a>Turning on \n                  			 <span class=\"MenuCascade\" id=\"GUID-A5BD65BF-5F9B-429E-896B-36C33CFA4AFC\">Auto Resize</span> can increase simulation speed, reduce memory use, creating smaller fluid cache files,\n                  and decrease fluid render time. \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5B06\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-7057B465-D25F-4CB8-BC94-CCAC52AF349F-low.png\"></div> \n               <p><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5B05\"></a>Notice that the fluid does not look or behave like smoke and flames. To improve the\n                  effect you will do the following: \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF45564F421269B08A8E9136C\"></a><ul>\n                  <li>Reduce the fluid emission rate so that the fluid emits less density and temperature\n                     into the container. This helps create the wispy smoke suitable for the effect. \n                     			 \n                  </li>\n                  <li>Adjust the density \n                     				<span class=\"MenuCascade\" id=\"GUID-C36AB208-263F-45E0-8A74-F8CB6133DB9A\">Dissipation</span> attribute, so that the smoke gradually dissipates after it is emitted. For this effect,\n                     the smoke density should dissipate fairly quickly. \n                     			 \n                  </li>\n               </ul> \n            </li>\n         </ol>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5B04\"></a> \n            <h2><a name=\"GUID-84616EF5-3524-4DB0-81ED-2E9E91DBCC8F\"></a>Adjusting fluid emission\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5B03\"></a>In this section of the lesson, you set attributes to control how the fluid contents\n               emit into the container. For this effect, you emit \n               		  <span class=\"MenuCascade\" id=\"GUID-C18DA356-09EC-42F5-8352-2A1D0CD6D856\">Density</span> and \n               		  <span class=\"MenuCascade\" id=\"GUID-26AFCBD6-856C-4655-9CDD-525EADC32AA0\">Heat</span> into the container. You also add \n               		  <span class=\"MenuCascade\" id=\"GUID-7C577697-75DB-4BB2-B46A-784E208A22F7\">Turbulence</span>, to add swirling motion to the fluid. \n               		\n            </p> \n            <p><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5B02\"></a>For more information about fluid effects, see the \n               		  <em class=\"mild\">Fluid Effects</em> section in the Maya Help. \n               		\n            </p> <a name=\"WS1A9193826455F5FF45564F421269B08A8E91370\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF45564F421269B08A8E91371\"></a>To adjust the fluid emission\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-0B748995-3D1E-492E-9312-DE5E05BD9C9C\">Attribute Editor</span>, click the \n                  			 <span class=\"MenuCascade\" id=\"GUID-3037ACA4-F411-4889-A8C3-BFC486F2FFF3\">emitter_slag_smoke</span> tab. \n                  			 \n                  <p><a name=\"WS73099CC142F4875516078EA312754F1D2D4-7776\"></a>If you do not have the fluid selected, you access the fluid emitter object through\n                     the \n                     				<span class=\"MenuCascade\" id=\"GUID-25B84A92-7F0F-4F00-8C34-A85EBB0ED0AA\">Outliner</span> by expanding \n                     				<em class=\"mild\">geo_slag</em> and selecting<em class=\"mild\"> emitter_slag_smoke1</em>. \n                     			 \n                  </p> \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-60786300-D565-4B3E-B91E-DC5A5D56DC05\">Basic Emitter Attributes</span> section, do the following: \n                  			 <a name=\"WS1A9193826455F5FF45564F421269B08A8E91374\"></a><ul>\n                     <li>Turn on \n                        				  <span class=\"MenuCascade\" id=\"GUID-B91AF504-0C42-42E6-936A-FF717E682F3B\">Use Distance</span>. \n                        				\n                     </li>\n                     <li>Set \n                        				  <span class=\"MenuCascade\" id=\"GUID-FD6E4E78-C3C1-4C0D-AB72-E8F2D189F4F5\">Min Distance</span> to 0.06. \n                        				\n                     </li>\n                     <li>Set \n                        				  <span class=\"MenuCascade\" id=\"GUID-B5480AA8-8253-42F2-B22A-515F374913D1\">Max Distance</span> to 0.44. \n                        				\n                     </li>\n                  </ul> \n                  <p><a name=\"WS1A9193826455F5FF45564F421269B08A8E91378\"></a>These values define the minimum and maximum distance that fluid is emitted from the\n                     mesh surface. \n                     			 \n                  </p> \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-C806AB45-EA18-4D84-9F49-2F5153A04E39\">Fluid Attributes</span> section, set the rate of \n                  			 <span class=\"MenuCascade\" id=\"GUID-92F17A11-F0E1-491E-AA26-C973D2D950BE\">Density</span> and \n                  			 <span class=\"MenuCascade\" id=\"GUID-858F0CE7-4CFE-47F5-8D9B-F0D7BC43AA18\">Heat</span> emission in the fluid container as follows: \n                  			 <a name=\"WS1A9193826455F5FF45564F421269B08A8E9137A\"></a><ul>\n                     <li><span class=\"MenuCascade\" id=\"GUID-F4E408D4-3A34-4F1B-B543-9AA702E4292E\">Density/Voxel/Sec</span>: 0.28 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-EB6FADDD-94AD-428B-A04C-443653D22998\">Heat/Voxel/Sec</span>: 0.4 \n                        				\n                     </li>\n                  </ul> \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-C248D33F-2F03-4F59-A5CD-AEA76C86F538\">Fluid Emission Turbulence</span> section, set \n                  			 <span class=\"MenuCascade\" id=\"GUID-F9D20E0F-8AD4-4D86-B365-BC854EFA325C\">Turbulence</span> to 6.3. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5AFF\"></a>This adds turbulence to the \n                     				<span class=\"MenuCascade\" id=\"GUID-14975C35-FE1F-411B-A423-9C61C3404A61\">Density</span> and \n                     				<span class=\"MenuCascade\" id=\"GUID-81FF1216-856A-46BA-9937-FF1375404F90\">Heat</span> as they emit into the container, which generates additional movement in the fluid.\n                     \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5AFE\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-6BBC7D4C-B5D5-4E17-9A60-D4779A8D82FF-low.png\"></div> \n               </li>\n               <li>Rewind and play the simulation. \n                  			 \n                  <p><a name=\"WS73099CC142F48755-5DCDA9B6127315F9A85-7637\"></a>Notice that the fluid emission is less dense, but there is little motion in the fluid.\n                     In the next section, you set fluidShape node attributes to add detail and movement\n                     to the smoke. \n                     			 \n                  </p> \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5AFC\"></a> \n            <h2><a name=\"GUID-14AFBBAA-A586-4430-869A-73DA2FCBFA1F\"></a>Setting fluidShape node attributes\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5AFB\"></a>Next, you will adjust the \n               		  <span class=\"MenuCascade\" id=\"GUID-32993CE0-0680-4A35-A7A4-3D47E49FFC10\">Buoyancy</span> and \n               		  <span class=\"MenuCascade\" id=\"GUID-F20512FE-7443-41A7-95E2-A8E9E1777444\">Dissipation</span> attributes to define the behavior of the \n               		  <span class=\"MenuCascade\" id=\"GUID-EC87F582-B6A6-4F5E-8DE8-770A983AFDB6\">Density</span> and \n               		  <span class=\"MenuCascade\" id=\"GUID-C89D6503-7CBD-49D7-B8F4-AEE36CA4544B\">Heat</span> in the fluid container after emission. \n               		\n            </p> <a name=\"WS1A9193826455F5FF45564F421269B08A8E9137E\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF45564F421269B08A8E9137F\"></a>To set the fluidShape node attributes\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-F971377A-FC67-48F3-91CA-3B30F173F9D6\">Attribute Editor</span>, click the fluid_slag_smokeShape tab. \n                  		  \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-18C64150-E1FD-46FC-80E2-FF015D246566\">Contents Method</span> section, set \n                  			 <span class=\"MenuCascade\" id=\"GUID-BBDC27DE-519E-4011-A992-CEAA1921F589\">Temperature</span> to \n                  			 <span class=\"MenuCascade\" id=\"GUID-98C231CF-C926-4550-A219-61B97DEA78D7\">Dynamic Grid</span>. \n                  		  \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-DB54373F-E744-43CA-8589-3B023217AE10\">Contents Details</span> section, click \n                  			 <span class=\"MenuCascade\" id=\"GUID-4D8DB7F8-1356-4205-A7E1-F5E2F19EA74D\">Density</span>, and set the following: \n                  			 <a name=\"WS1A9193826455F5FF45564F421269B08A8E91383\"></a><ul>\n                     <li><span class=\"MenuCascade\" id=\"GUID-21D49286-9567-4D1E-862B-595A39C482E8\">Buoyancy</span>: 0.31 \n                        				  \n                        <p><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5AFA\"></a>This determines the tendency of the \n                           					 <span class=\"MenuCascade\" id=\"GUID-9DEC60D9-8194-4072-9ED4-7D283044A167\">Density</span> to rise in the container, similar to the way a lighter-than-air gas rises in the\n                           atmosphere. Decreasing<span class=\"MenuCascade\" id=\"GUID-9B7F7760-D3D4-4187-ACB6-AD931BDD932F\"> Buoyancy</span> will keep the fluid from rising and increasing in size. \n                           				  \n                        </p> \n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-8573DBD0-DA02-4504-975F-885FCF59E2E4\">Dissipation</span>: 3.0 \n                        				  \n                        <p><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5AF9\"></a>This determines how quickly \n                           					 <span class=\"MenuCascade\" id=\"GUID-2088D3A3-97EE-4484-83E2-19F0FB77B2D0\">Density</span> is removed from the container similar to evaporation. Increasing \n                           					 <span class=\"MenuCascade\" id=\"GUID-1A2EF092-D49F-45E2-9F14-3B576A536683\">Dissipation</span> causes the \n                           					 <span class=\"MenuCascade\" id=\"GUID-83AA73D3-14C7-48A4-95DF-3C12E6F8DD4C\">Density</span> to dissipate quicker into the air. \n                           				  \n                        </p> \n                     </li>\n                  </ul> <a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5AF8\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-80FF62F3-D2DA-4159-877C-5509F82FC6D5-low.png\"></div> \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-6340B3DC-077F-466C-A3BD-67359012F833\">Temperature</span> section, set the following: \n                  			 <a name=\"WS1A9193826455F5FF45564F421269B08A8E91389\"></a><ul>\n                     <li><span class=\"MenuCascade\" id=\"GUID-2A4C7CE8-816D-42FD-B191-BBD0264A4F2A\">Temperature Scale</span>: 0.5 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-FE7396B5-063A-497A-BBB7-F19C8665F67F\">Buoyancy</span>: 30.0 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-433EB874-2A6E-44CD-A3B2-493AB4D4F8DA\">Dissipation</span>: 3.0 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-80F66DE3-224C-4337-980E-0A5855EE4A63\">Diffusion</span>: 0.0 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-E79A8BEB-6596-4DEE-9D97-9F4268F64EAE\">Turbulence</span>: 10 \n                        				  \n                        <p><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5AF7\"></a>Setting these attributes adds movement to the \n                           					 <span class=\"MenuCascade\" id=\"GUID-5EC889E6-2452-44A8-BE8D-5A48DC4C00A2\">Heat \n                              					 </span>in the container, but they do not affect \n                           					 <span class=\"MenuCascade\" id=\"GUID-3EA2B047-D75E-430C-AD0C-B432668D2D9A\">Density</span>. \n                           				  \n                        </p> \n                     </li>\n                  </ul> <a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5AF6\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-A8FFB844-AA4E-4868-B9EA-3936877E7F09-low.png\"></div> \n               </li>\n               <li>Rewind and play the simulation. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF7B1DE9F8127315F1B54-5AF4\"></a>The fluid appears more subtle in the scene, but it is difficult to see how the \n                     				<span class=\"MenuCascade\" id=\"GUID-C49A0AA1-6571-4350-B519-0A60C2B48B4E\">Density \n                        				</span>and \n                     				<span class=\"MenuCascade\" id=\"GUID-0C8052DD-8602-42CD-8817-CF3129A6E7CF\">Temperature</span> attribute adjustments have affected its behavior. Before setting the fluid \n                     				<span class=\"MenuCascade\" id=\"GUID-D585EE11-7F35-41B9-9F74-56A7BF343FC7\">Shading</span> attributes to color the fluid, you can increase the fluid resolution to make the\n                     fluid\'s behavior easier to see. Be aware that increasing fluid resolution increased\n                     simulation time. \n                     			 \n                  </p> <a name=\"WS73099CC142F48755-5DCDA9B6127315F9A85-7636\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-077D4DD5-4C9D-404F-A0C1-868C768F77D8-low.png\"></div> \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-B88D3AC7-E432-4FE1-8A87-95AA14C2F399\">Container Properties</span> section, set the \n                  			 <span class=\"MenuCascade\" id=\"GUID-6D76B4F7-F66E-4D68-BEA5-6F5E50CB0357\">Base Resolution \n                     			 </span>to 30. \n                  			 <a name=\"WS73099CC142F48755-5DCDA9B6127315F9A85-7634\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-A24EF0E0-344F-419D-88B8-EDECC54B50E3-low.png\"></div> \n               </li>\n               <li>Rewind and play the simulation. \n                  			 \n                  <p><a name=\"WS73099CC142F48755-5DCDA9B6127315F9A85-7632\"></a>The fluid behavior is now much easier to assess. \n                     			 \n                  </p> <a name=\"WS73099CC142F48755-5DCDA9B6127315F9A85-7631\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-F5B91991-EAAE-425B-AEEA-2FAE0042AD6F-low.png\"></div> \n               </li>\n            </ol> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";